// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;

//texture
texture Tex <string uiname="Texture";>;


float yBlend_Top=1;
float yBlend_Bot=-1;
float xBlend_Left=-1;
float xBlend_Right=1;
float blendWidth=0.1;
float3 gammaRGB=1;

//texture projection properties
//bool useProjection=false; // false=use vertex tex coords, true=use world coords
//float4x4 tProjector;

//viewports
int ViewIndex: VIEWPORTINDEX;
int ViewCount: VIEWPORTCOUNT;
int ViewIndexIN;

//samplers
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};


//texture transformation marked with semantic TEXTUREMATRIX to achieve symmetric transformations
float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;

//alpha
float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

//include the bicubic texture lookup
//#include "Bicubic.fxh"

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float4 TexCd : TEXCOORD0;
    float4 PosW : TEXCOORD1;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 PosO  : POSITION,
    float4 TexCd : TEXCOORD0
    )
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

    //transform position
	PosO.xyz*=(ViewIndexIN==ViewIndex);//Make it visible within view port by scaling to 0 if not. Watch Spreaded objects...
    Out.Pos = mul(PosO, tWVP);
    float4 PosW = mul(PosO, tW);

    //transform texturecoordinates
//    if (useProjection)
//    {
//    	//tProjector=mul(tProjector,tTex);
///        Out.TexCd = mul(PosW, tProjector);
//    }
//    else
        Out.TexCd = mul(TexCd, tTex);
    
    Out.PosW = mul(PosO, tW);
    
    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float3 factorY(float pos)
{
  //  int ViewIndexMapped = ViewIndex;
 //   float yTop = yBlends[ViewIndexMapped-1];
 //   float yBase = yBlends[ViewIndexMapped];
    float yTop = yBlend_Bot;
    float yBase = yBlend_Top;

    float factortop = smoothstep(yTop-blendWidth/2,
                                 yTop+blendWidth/2,
                                 pos);
  //  if (ViewIndexMapped==0)
  //      factortop=1;


    float factorbottom = 1-smoothstep(yBase-blendWidth/2,
                                 yBase+blendWidth/2,
                                 pos);
 //   if (ViewIndexMapped==ViewCount-1)
  //      factorbottom=1;

    return pow(factortop * factorbottom, gammaRGB);
}
float3 factorX(float pos)
{
  //  int ViewIndexMapped =ViewIndex;
 //   float yTop = yBlends[ViewIndexMapped-1];
 //   float yBase = yBlends[ViewIndexMapped];
    float xTop = xBlend_Left;
    float xBase = xBlend_Right;

    float factortopX = smoothstep(xTop-blendWidth/2,
                                 xTop+blendWidth/2,
                                 pos);
   float factorbottomX = 1-smoothstep(xBase-blendWidth/2,
                                 xBase+blendWidth/2,
                                 pos);
    return pow(factortopX * factorbottomX, gammaRGB);
}



// PS Bicubic
float4 SpatialSoftEdge(vs2ps In) : COLOR
{
  //In.TexCd /= In.TexCd.w;
 // In.TexCd.xy+=1;
 // In.TexCd.xy /=2;
 // In.TexCd.y=1-In.TexCd.y;

  float4 col = tex2D(Samp, In.TexCd);
  
  col.a *= Alpha;
  
  col.rgb *= factorY(In.PosW.y);
   col.rgb *= factorX(In.PosW.x);
  
  
  return col;
}


technique Bicubic
{
    pass p0
    {
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_3_0 SpatialSoftEdge();
    	
    }
	
}

